package jadean.dean.java.resourceparser.javaparser;

import jadean.dean.Resource;
import jadean.dean.exceptions.ResourceIOException;
import jadean.dean.exceptions.ResourceInvalidException;
import jadean.dean.exceptions.ResourceNotFoundException;
import jadean.dean.java.JavaResource;
import jadean.dean.java.resourceparser.JavaResourceFilter;
import jadean.dean.java.resourceparser.JavaResourceParser;
import jadean.dean.java.resourceparser.javaparser.visitors.GetReferencedClassesVisitor;
import jadean.dean.java.resourceparser.javaparser.visitors.IsReflectionUsedVisitor;
import japa.parser.JavaParser;
import japa.parser.ParseException;
import japa.parser.ast.CompilationUnit;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;


public class JavaSourceResourceParser extends JavaResourceParser {

	private FileInputStream javaSourceFile;

	public JavaSourceResourceParser(String javaSourceFileName) throws ResourceNotFoundException {
		super(javaSourceFileName);
		try {
			this.javaSourceFile = new FileInputStream(javaSourceFileName);
		}
		catch (IOException e) {
			throw new ResourceNotFoundException();
		}		
	}

	@Override
	public Collection<Resource> getReferencedResources() throws ResourceIOException, ResourceInvalidException {
		try {
			CompilationUnit sourceFileCompilationUnit = JavaParser.parse(this.javaSourceFile);
			GetReferencedClassesVisitor<String> sourceFileVisitor = new GetReferencedClassesVisitor<String>();
			sourceFileVisitor.visit(sourceFileCompilationUnit, null);
			HashSet<JavaResource> referencedClasses = sourceFileVisitor.getReferencedClasses();
			JavaResourceFilter resourceFilter = new JavaSourceResourceFilter();
			HashSet<Resource> resourcesSet = new HashSet<Resource>();
			for (JavaResource referencedClass: referencedClasses) {
				if (resourceFilter.accept(referencedClass)) {
					resourcesSet.add(referencedClass);
				}
			}
			return resourcesSet;
		}
		catch (ParseException e) {
			throw new ResourceInvalidException("PARSE");
		}
	}

	public boolean isReflectionUsed() {
		try {
			CompilationUnit sourceFileCompilationUnit = JavaParser.parse(this.javaSourceFile);
			IsReflectionUsedVisitor<String> isReflectionUsedVisitor = new IsReflectionUsedVisitor<String>();
			isReflectionUsedVisitor.visit(sourceFileCompilationUnit, null);
			return isReflectionUsedVisitor.isReflectionUsed();
		}
		catch (ParseException e) {
			return false;
		}		
	}

}
